<?php

include "QRCodeGenerator.class.php";

function product_name($name)
{
    return character_limiter($name, (isset($Settings->char_per_line) ? ($Settings->char_per_line-8) : 35));
}

if ($modal) {
    echo '<div class="modal-dialog no-modal-header"><div class="modal-content"><div class="modal-body"><button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i></button>';
} else { ?>
    <!doctype html>
    <html>
    <head>
        <meta charset="utf-8">
        <title><?= $page_title . ": " . $inv->id; ?></title>
        <base href="<?= base_url() ?>"/>
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
        <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width: 480px; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 5px; }         .table { border-radius: 3px; }
            .table th { background: #f5f5f5; }           .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            @media print { .no-print { display: none; }
                #wrapper { max-width: 480px; width: 100%; min-width: 250px; margin: 0 auto; }
            }
        </style>
    </head>
    <body>
<?php } ?>
<div id="wrapper">
    <div id="receiptData">
    <div class="no-print">
        <?php if ($message) { ?>
            <div class="alert alert-success">
                <button data-dismiss="alert" class="close" type="button">×</button>
                <?= is_array($message) ? print_r($message, true) : $message; ?>
            </div>
        <?php } ?>
      <?php if ($Settings->java_applet) { ?>
        <span class="col-xs-12"><a class="btn btn-block btn-primary" onClick="printReceipt()"><?= lang("print"); ?></a></span>
        <span class="col-xs-12"><a class="btn btn-block btn-info" type="button" onClick="openCashDrawer()"><?= lang('open_cash_drawer'); ?></a></span>
        <div style="clear:both;"></div>
    <?php } else { ?>

    <span class="col-xs-12">
        <a class="btn btn-block btn-warning" href="<?= site_url('pos'); ?>"><?= lang("back_to_pos"); ?></a>
    </span>

    <span class="pull-right col-xs-12">
        <a href="javascript:window.print()" id="web_print" class="btn btn-block btn-primary" onClick="window.print();return false;">Imprimir</a>
    </span>
    <?php if($inv->nf_status==""){ ?>
    <span class="pull-left col-xs-12" style="margin-bottom:30px;">
        <a onClick="MyWindow2=window.open('pos/nfe/<?=$inv->id; ?>/1/emitir', 'MyWindow2','toolbar=0,location=0,directories=0,status=0,menubar=yes,scrollbars=yes,resizable=yes,width=700,height=800'); return false;" href="javascript:void(0)"  class="btn btn-block btn-success">Gerar NFC-e</a></span>
    <?php } ?>
        
    <?php 
    } ?>
 
    </div>
    <div id="receipt-data">
        <div class="text-center">
                <?= $Settings->header; ?>
                <p>
                  <?= lang("customer").': '. $inv->customer_name; ?><br>
                 <b><?= lang('sale').'/Cupom:</b> '.$inv->id; ?>&nbsp;&nbsp;&nbsp;&nbsp;<b>Data: </b><? echo $this->tec->hrld($inv->date); ?>
                </p>
            <div style="clear:both;"></div>
            <table class="table table-striped table-condensed">
                <thead>
                    <tr>
                        <th class="text-center col-xs-6"><?=lang('description');?></th>
                        <th class="text-center col-xs-1"><?=lang('quantity');?></th>
                        <th class="text-center col-xs-2"><?=lang('price');?></th>
                        <th class="text-center col-xs-3"><?=lang('subtotal');?></th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $tax_summary = array();
                foreach ($rows as $row) {
                    echo '<tr><td class="text-left">' . product_name($row->product_name) . '</td>';
                    echo '<td class="text-center">' . $this->tec->formatNumber($row->quantity) . '</td>';
                    echo '<td class="text-right">';

                    if ($inv->total_discount != 0) {
                        $price_with_discount = $this->tec->formatMoney($row->net_unit_price + $this->tec->formatDecimal($row->item_discount / $row->quantity));
                        $pr_tax = $row->tax_method ?
                        $this->tec->formatDecimal((($price_with_discount) * $row->tax) / 100) :
                        $this->tec->formatDecimal((($price_with_discount) * $row->tax) / (100 + $row->tax));
                        echo '<del>' . $this->tec->formatMoney($price_with_discount+$pr_tax) . '</del> ';
                    }

                    echo $this->tec->formatMoney($row->net_unit_price + ($row->item_tax / $row->quantity)) . '</td><td class="text-right">' . $this->tec->formatMoney($row->subtotal) . '</td></tr>';
                }
                ?>
                </tbody>
                <tfoot>
                <tr>
                    <th colspan="2"><?= lang("total"); ?></th>
                    <th colspan="2" class="text-right">R$ <?= $this->tec->formatMoney($inv->total + $inv->product_tax); ?></th>
                </tr>
                <?php
                if ($inv->order_tax != 0) {
                    echo '<tr><th colspan="2">' . lang("order_tax") . '</th><th colspan="2" class="text-right">' . $this->tec->formatMoney($inv->order_tax) . '</th></tr>';
                }
                if ($inv->total_discount != 0) {
                    echo '<tr><th colspan="2">' . lang("order_discount") . '</th><th colspan="2" class="text-right">' . $this->tec->formatMoney($inv->total_discount) . '</th></tr>';
                }

                if ($Settings->rounding) {
                    $round_total = $this->tec->roundNumber($inv->grand_total, $Settings->rounding);
                    $rounding = $this->tec->formatMoney($round_total - $inv->grand_total);
                ?>
                    <tr>
                        <th colspan="2"><?= lang("rounding"); ?></th>
                        <th colspan="2" class="text-right">R$ <?= $rounding; ?></th>
                    </tr>
                    <tr>
                        <th colspan="2"><?= lang("grand_total"); ?></th>
                        <th colspan="2" class="text-right">R$ <?= $this->tec->formatMoney($inv->grand_total + $rounding); ?></th>
                    </tr>
                <?php
                } else {
                    $round_total = $inv->grand_total;
                    ?>
                    <tr>
                        <th colspan="2"><?= lang("grand_total"); ?></th>
                        <th colspan="2" class="text-right"> R$ <?= $this->tec->formatMoney($inv->grand_total); ?></th>
                    </tr>
                <?php }
                if ($inv->paid < $round_total) { ?>
                    <!-- <tr>
                        <th colspan="2">Valor total pago</th>
                        <th colspan="2" class="text-right">R$ <?= $this->tec->formatMoney($inv->paid+$payment->pos_balance); ?></th>
                    </tr>
                   <tr>
                        <th colspan="2"><?= lang("due_amount"); ?></th>
                        <th colspan="2" class="text-right"><?= $this->tec->formatMoney($inv->grand_total - $inv->paid); ?></th>
                    </tr>-->
                <?php } ?>
                </tfoot>
            </table>
            <?php
            if ($payments) {
            	
                foreach($meiopagamento as $pagamento){ $pag[$pagamento->cod] = $pagamento->nome; }
                
               echo '<table class="table table-striped table-condensed"><tbody>';
               foreach ($payments as $payment) {
                   echo '<tr>';
                   if ($payment->paid_by == 'cash' && $payment->pos_paid) {
                       echo '<td>' . lang("paid_by") . ': ' . $pag[$payment->paid_by] . '</td>';
                       echo '<td>' . lang("amount") . ': R$ ' . $this->tec->formatMoney($payment->amount+$payment->pos_balance) . '</td>';
                       echo '<td>' . lang("change") . ': R$ ' . $this->tec->formatMoney($payment->pos_balance). '</td>';
                   }
               
                   elseif (($payment->paid_by == 'CC' || $payment->paid_by == 'ppp' || $payment->paid_by == 'stripe')) {
                       echo '</tr>';
                       echo '<tr>';
                       echo '<td>' . lang("paid_by") . ': ' . $pag[$payment->paid_by] . '</td>';
                       echo '<td>' . lang("amount") . ': R$ ' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                       if($payment->pos_balance > 0) echo '<td>' . lang("balance") . ': ' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0) . '</td>';
                       echo '<td>Parcelas: ' . $payment->cc_holder . 'x (' . $payment->cc_type . ')</td>';
                                 
                   }
                   
                   elseif ($payment->paid_by == 'Cheque' && $payment->cheque_no) {
                       echo '<td>' . lang("paid_by") . ': ' . $pag[$payment->paid_by] . '</td>';
                       echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                       echo '<td>' . lang("cheque_no") . ': ' . $payment->cheque_no . '</td>';
                   }
                   elseif ($payment->paid_by == 'gift_card' && $payment->pos_paid) {
                       echo '<td>' . lang("paid_by") . ': ' . $pag[$payment->paid_by] . '</td>';
                       echo '<td>' . lang("no") . ': ' . $payment->gc_no . '</td>';
                       echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                       echo '<td>' . lang("balance") . ': ' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0) . '</td>';
                   }
                  else if ($payment->paid_by == 'other' && $payment->amount) {
                       echo '<td>' . lang("paid_by") . ': ' . $pag[$payment->paid_by] . '</td>';
                       echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid) . '</td>';
                       echo $payment->note ? '</tr><td colspan="2">' . lang("payment_note") . ': ' . $payment->note . '</td>' : '';
                   }
                   
                   else{
                       echo '<td>' . lang("paid_by") . ': ' . $pag[$payment->paid_by] . '</td>';
                       echo '<td>' . lang("amount") . ': R$ ' . $this->tec->formatMoney($payment->amount+$payment->pos_balance) . '</td>';
                       echo '<td>' . lang("change") . ': R$ ' . $this->tec->formatMoney($payment->pos_balance). '</td>';
                   }
                   
                   
                   
                   echo '</tr>';
               }
               echo '</tbody></table>';

           }

            ?>

            <?= $inv->note ? '<p class="text-center">' . $this->tec->decode_html($inv->note) . '</p>' : ''; ?>
        </div>
        <div style="clear:both;"></div>
    </div>
<?php if ($modal) {
    echo '</div></div></div></div>';
} else { ?>
<div id="buttons" style="padding-top:10px; text-transform:uppercase;" class="no-print">
    <hr>
    <?php if ($message) { ?>
    <div class="alert alert-success">
        <button data-dismiss="alert" class="close" type="button">×</button>
        <?= is_array($message) ? print_r($message, true) : $message; ?>
    </div>
<?php } ?>

<?php } ?>
 <div style="clear:both;"></div>
</div>
</div>

