<script>
	$(document).ready(function () {
		$('#SLData').dataTable({
			"aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, '<?= lang('all'); ?>']],
            "aaSorting": [[ 0, "desc" ]], "iDisplayLength": <?= $Settings->rows_per_page ?>,
			'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= site_url('sales/get_notasfiscais') ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            "aoColumns": [null, null, null, null, {"bSortable":false, "bSearchable": false}]
		});
	});
	
	function exportXML(modelo){
	    
		$.ajax({url: base_url + "api-nfe/gerador/ExportarXML.php?codigoUF=<?= $Settings->codigoUF ?>&cnpj=<? echo str_replace(array(".", ",", "-", " ", "/"), "", $Settings->vat_no); ?>&modelo=" + modelo +"&mes=" + $("#messelect").val(), type: "POST", dataType: 'jsonp', success: function(data){
			  if(data.result){ 
				   window.open(base_url + "api-nfe/gerador/" + data.url, '_blank');
			  }else{
				  alert("Erro ao exportar notas modelo ("+ modelo +"), tente novamente");
			  }
		   }
		});
		   
	   }
</script>

<section class="content">
	<div class="row">
	
		<div class="col-xs-12">
			<div class="box box-primary">
				<div class="box-header">
					<h3 class="box-title"><?= lang('list_results'); ?></h3>
				</div>
				<div class="box-body">
				<select id="messelect" style="width:170px;">
            	       <option value="">Selecione...</option>
            	       <option value="01">Janeiro</option>
            	       <option value="02">Fevereiro</option>
            	       <option value="03">Março</option>
            	       <option value="04">Abril</option>
            	       <option value="05">Maio</option>
            	       <option value="06">Junho</option>
            	       <option value="07">Julho</option>
            	       <option value="08">Agosto</option>
            	       <option value="09">Setembro</option>
            	       <option value="10">Outubro</option>
            	       <option value="11">Novembro</option>
            	       <option value="12">Dezembro</option>
            	   </select> <button type="button" onclick="exportXML(65)" class="btn btn-success">Exportar NFC</button> <button type="button" onclick="exportXML(55)"  class="btn btn-success">Exportar NF</button>  <a onClick="MyWindow3=window.open('<?= site_url('pos/nfe_contingencia') ?>', 'MyWindow3','toolbar=0,location=0,directories=0,status=0,menubar=yes,scrollbars=yes,resizable=yes,width=700,height=800'); return false;" href="javascript:void(0)"  class="btn btn-warning">Enviar Notas Contingência</a></span>
   
            	 </div> 
				<div class="box-body">
					<div class="table-responsive">
						<table id="SLData" class="table table-striped table-bordered table-condensed table-hover">
							<thead>
								<tr class="active">
									<th style="width: 50px;"><?php echo $this->lang->line("date"); ?></th>
									<th class="col-xs-1">Número</th>
									<th class="col-xs-1">Status</th>
									<th class="col-xs-1">Chave</th>
									<th style="width:20px; text-align:center;"><?php echo $this->lang->line("actions"); ?></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td colspan="9" class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
	</div>
</section>