<?php
namespace TudonetNF;
	
class NFe {
    
    function __construct( array $vars ){
        
        $this->consumerKey = $vars['consumer_key'];
        $this->consumerSecret = $vars['consumer_secret'];
        $this->accessToken = $vars['oauth_access_token'];
        $this->accessTokenSecret = $vars['oauth_access_token_secret'];
        
    }
    
    function statusSefaz(){
        $data = array();
        $response = self::Rest_TudonetNF( 'GET', 'https://tudonet.ml/nfe/1/Sefaz', $data );
        if (isset($response->error)) return $response;
        if ($response->status == 'online') return true;
        else return false;
        
    }
    
    function validadeCertificado(){
        $data = array();
        $response = self::Rest_TudonetNF( 'GET', 'https://tudonet.ml/nfe/1/Certificado', $data );
        if (isset($response->error)) return $response;
        return $response->expiration;     
    }
    
    function emissaoNotaFiscal( array $data ){
        
        $response = self::Rest_TudonetNF( 'GET', 'https://tudonet.ml/nfe/1/NFe', $data );
        return $response;
        
    }
    
    function consultaNotaFiscal( $chave ){
        
        $data = array();
        $data['chave'] = $chave;
        $response = self::Rest_TudonetNF( 'GET', 'https://tudonet.ml/nfe/1/Consulta', $data );
        return $response;
        
    }
    
    function cancelarNotaFiscal( $chave, $motivo ){
        
        $data = array();
        $data['chave'] = $chave;
        $data['motivo'] = $motivo;
        $response = self::Rest_TudonetNF( 'GET', 'https://tudonet.ml/nfe/1/Cancelar', $data );
        return $response;
        
    }
    
    function inutilizarNumeracao( $sequencia, $motivo ){
        
        $data = array();
        $data['sequencia'] = $sequencia;
        $data['motivo'] = $motivo;
        $response = self::Rest_TudonetNF( 'GET', 'https://tudonet.ml/nfe/1/inutilizar/', $data );
        return $response;
        
    }
    
    function Rest_TudonetNF( $request, $endpoint, $data ){
				
		$query = http_build_query($data);
		$rest = curl_init($endpoint."?token=".$this->accessToken."&".$query);
		curl_setopt($rest,CURLOPT_RETURNTRANSFER,true);
		$response = curl_exec($rest);
		curl_close($rest);

		return json_decode($response);
  
    }
    
}
?>